/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author youmingming
 * @version PosRefundStatusEnum.java, v 0.1 2022-05-15 3:47 PM youmingming
 */
public enum PosRefundStatusEnum {
    OPEN("开启", "1"),
    CLOSE("关闭", "0");

    private String name;
    private String value;

    PosRefundStatusEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static PosRefundStatusEnum getByValue(String value) {
        PosRefundStatusEnum[] valueList = PosRefundStatusEnum.values();
        for (PosRefundStatusEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }
}