package com.fshows.leshuapay.sdk.response.bill;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import lombok.Data;

import java.io.Serializable;

/**
 * @author huanghai
 * @version 1.0 AgentInvoiceListRequest
 * @date 2021/11/23 16:48
 */
@Data
public class AgentInvoiceDetailResponse implements Serializable {
    private static final long serialVersionUID = -4457315519329996414L;
    /**
     * 直属代理商编号
     */
    private String agentId;
    /**
     * 一级代理商编号
     */
    private String agentId1g;
    /**
     * 开票金额 单位：分
     */
    private Integer amount;

    /**
     * 	费用明细	string
     */
    private String feeDetail;
    /**
     * 费用类型
     */
    private Integer feeType;

    /**
     * 申请开票id
     */
    private Integer id;

    /**
     * 发票类型 0:普通增值税发票 1:专用增值税发票
     */
    private Integer invoiceType;

    /**
     * 商户编号	string
     */
    private String merchantId;
    /**
     * 商户名称	string
     */
    private String merchantName;
    /**
     * 开票状态 0待审核，1风控审核通过，2风控审核不通过，3开票中，4拒绝开票，5开票完成, 6已红冲, 99撤销申请	integer(int32)
     */
    private String status;

    /**
     * 发票类型子字段	发票类型父类
     */
    private SubInvoiceDetail subInvoiceDetail;
    /**
     * 	发票链接
     */
    private String url;

}
