/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.rate;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * 支付宝扫码费率
 *
 * @author zhaoyi
 * @version AlipayRate.java, v 0.1 2020-07-30 9:37 zhaoyi
 */
@Data
public class AlipayRate implements Serializable {


    private static final long serialVersionUID = -4035489536096405073L;
    /**
     * 支付宝扫码次日结算费率(开通扫码支付必传)
     */
    private FeeUnit t1;

    /**
     * 蓝海活动费率
     */
    private FeeUnit bluesea;

    /**
     * 0费率活动
     */
    private FeeUnit activityFee0;

    /**
     * 0.1费率活动
     */
    private FeeUnit activityFee0Dot1;

    /**
     * 线上
     */
    private FeeUnit online;

    /**
     * 支付宝扫码T0结算费率
     */
    private FeeUnit t0;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
