/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author youmingming
 * @version AccountSignTypeEnum.java, v 0.1 2021-04-01 11:46 上午 youmingming
 */
public enum AgentBillMethodEnum {
    AGENT_BILL_METHOD_LIST("查询可开票列表", "/agent-invoice/v1/list"),
    AGENT_BILL_METHOD_APPLY("申请开票", "/agent-invoice/v1/apply"),
    AGENT_BILL_METHOD_DETAIL("查询发票申请记录", "/agent-invoice/v1/detail"),
    AGENT_BILL_METHOD_REVOKE("撤销开票", "/agent-invoice/v1/revoke");

    private String name;
    private String value;

    AgentBillMethodEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static AgentBillMethodEnum getByValue(String value) {
        AgentBillMethodEnum[] valueList = AgentBillMethodEnum.values();
        for (AgentBillMethodEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }
}