/**
 * fshows.com
 * Copyright (C) 2013-2018 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.merchant;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.merchant.MerchantUpdateAuthorityResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author chenjn
 * @version MerchantUpdateAuthorityRequest.java, v 0.1 2021-12-09 1:44 PM chenjn
 */
@Data
public class MerchantUpdateAuthorityRequest extends LeshuaBizRequest<MerchantUpdateAuthorityResponse> {

    private static final long serialVersionUID = 5864053473428707550L;

    /**
     * 乐刷商户ID
     * 限制 10
     */
    @NotBlank
    private String merchantId;

    /**
     * wechat：微信
     * alipay：支付宝
     * unionscan：银联扫码
     */
    @NotBlank
    private String payWay;

    /**
     * 2：D0交易 3：D0结算
     */
    @NotNull
    private Integer type;

    /**
     * 1：开通 0：关闭
     */
    @NotNull
    private Integer flag;

    @Override
    public Class<MerchantUpdateAuthorityResponse> getResponseClass() {
        return MerchantUpdateAuthorityResponse.class;
    }
}