package com.fshows.leshuapay.sdk.response.settlement;/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author shijp
 * @version MerchantGetOrderSettleInfoResponse.java, v0.1 2022-01-17-6:14 下午 shijp
 */

@Data
public class MerchantGetOrderSettleInfoResponse implements Serializable {

    private static final long serialVersionUID = -2166147180880437529L;
    /**
     * 交易结算金额
     */
    private Integer amount;

    /**
     * 结算类型
     * 0：D0交易结算
     * 1：D1交易结算（含实时入账）
     */
    private Integer settleType;

    /**
    * 交易时间
    */
    private String tradeTime;

    /**
     * 手续费明细
     */
    private List<SettleInfoFeeDetail> feeDetails;

    /**
     * 总手续费金额
     */
    private Integer comisonAmt;
    
    /**
    * 乐刷商户号
    */
    private String merchantId;

    /**
     * 手续费时是否封顶
     * 0：否 1：是
     */
    private Integer maxFlag;

    /**
     * 分账标记
     * 0：普通交易订单；
     * 1：分账交易订单
     * 2：延迟结算交易订单；
     */
    private Integer royalty;

    /**
    * 计费清分时间
    */
    private String clearTime;

    /**
     * 结算金额
     */
    private Integer settleAmt;

    /**
     * 交易状态
     * 交易操作类型：-1：未知 0：交易成功 1：交易退款 2：交易退款失败 3：交易退货 4：交易退货失败 5：交易冲正 6：交易冲正失败 7：交易撤销 8：交易撤销失败
     */
    private Integer operType;

    /**
    * 乐刷流水ID
    */
    private String flowId;

    /**
     * 交易类型
     * 1：刷卡
     * 2: 微信
     * 3: 支付宝
     * 6: 银联扫码
     */
    private Integer payType;

    /**
    * 乐刷交易订单号
    */
    private String orderId;
}
