package com.fshows.leshuapay.sdk.request.bill;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.bill.AgentInvoiceListResponse;
import lombok.Data;

/**
 * @author huanghai
 * @version 1.0 AgentInvoiceListRequest
 * @date 2021/11/23 16:48
 */
@Data
public class AgentInvoiceListRequest extends  LeshuaBizRequest<AgentInvoiceListResponse> {
    /**
     * 直属代理商id
     */
    private String currentAgentId;

    /**
     * 记录起始时间 格式YYYY-MM-dd HH:mm:ss
     */
    private String startTime;

    /**
     * 记录结束时间 格式YYYY-MM-dd HH:mm:ss
     */
    private String endTime;

    /**
     * 开票类型 0:交易手续费 1:其他
     */
    private String feeType;

    /**
     *商户id
     */
    private String merchantId;

    /**
     * 页码 默认第一页，每页固定20条
     */
    private Integer pageNo;

    @Override
    public Class<AgentInvoiceListResponse> getResponseClass() {
        return AgentInvoiceListResponse.class;
    }
}
