package com.fshows.leshuapay.sdk.request.bill;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.bill.AgentInvoiceMergeApplyResponse;
import lombok.Data;

/**
 * @author huanghai
 * @version 1.0 AgentInvoiceListRequest
 * @date 2021/11/23 16:48
 */
@Data
public class AgentInvoiceMergeApplyRequest extends  LeshuaBizRequest<AgentInvoiceMergeApplyResponse> {

    /**
     *开户账号
     */
    private String bankAccount;
    /**
     *开户行
     */
    private String bankName;
    /**
     *费用明细
     */
    private String feeDetail;
    /**
     *可开票记录id列表， 已逗号隔开 1,2,3,4,5
     */
    private String id;

    /**
     *开票抬头
     */
    private String invoiceTitle;
    /**
     *	开票类型 0:普通增值税发票 1:专用增值税发票
     */
    private Integer invoiceType;

    /**
     *登记电话
     */
    private String phone;
    /**
     *收件人邮箱 开普通增值税发票时必传
     */
    private  String receiveEmail;
    /**
     *收件人手机号 开普通增值税发票时必传
     */
    private String receivePhone;
    /**
     *注册地址
     */
    private String registerAddress;
    /**
     *申请开票备注，最大100个字符
     */
    private String remark;
    /**
     *	纳税人识别号
     */
    private String taxpayerNum;
    /**
     * 一般纳税人证明图片Url 开专用增值税发票时必传,需要先调用乐刷图片上传接口得到图片url地址，
     * 图片上传接口见：https://www.yuque.com/leshuazf/doc/spomzg#IkGZE
     */
    private String taxpayerPic;
    /**
     * 开票备注  最大100个字符
     */
    private String message;


    @Override
    public Class<AgentInvoiceMergeApplyResponse> getResponseClass() {
        return AgentInvoiceMergeApplyResponse.class;
    }
}
