/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

/**
 * 结算标记枚举
 *
 * @author zhaoyi
 * @version LegalFlagEnum.java, v 0.1 2020-08-03 10:56 zhaoyi
 */
public enum LegalFlagEnum {
    UNINCORPORATED_SETTLEMENT(0, "非法人结算"),
    CORPORATE_SETTLEMENT(1, "法人结算"),
    ;

    private Integer type;
    private String desc;

    LegalFlagEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static LegalFlagEnum getByType(Integer type) {
        LegalFlagEnum[] valueList = LegalFlagEnum.values();
        for (LegalFlagEnum v : valueList) {
            if (v.getType().equals(type)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>type</tt>.
     *
     * @return property value of type
     */
    public Integer getType() {
        return type;
    }

    /**
     * Getter method for property <tt>desc</tt>.
     *
     * @return property value of desc
     */
    public String getDesc() {
        return desc;
    }
}
