package com.fshows.leshuapay.sdk.client;

import com.fshows.leshuapay.sdk.exception.LeshuaException;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.bill.LeshuaBillBaseResponse;

import java.util.List;

/**
 * @author huanghai
 * @version 1.0 LeshuaMerchantBillClient
 * @date 2021/11/23 16:04
 */
public interface LeshuaMerchantBillClient {
    /**
     * 乐刷发票相关
     *
     * @param request 商户入参
     * @param url     实际业务请求地址
     * @param timeout 超时设置，单位毫秒
     * @param <T>
     * @return
     * @throws LeshuaException
     */
    <T> LeshuaBillBaseResponse<T> execute(LeshuaBizRequest<T> request, String url, Integer timeout) throws LeshuaException;


    /**
     * 乐刷发票相关
     *
     * @param request 商户入参
     * @param url     实际业务请求地址
     * @param timeout 超时设置，单位毫秒
     * @param <T>
     * @return
     * @throws LeshuaException
     */
    <T> LeshuaBillBaseResponse<List<T>> executeList(LeshuaBizRequest<T> request, String url, Integer timeout) throws LeshuaException;

}
