/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.response.merchant.riskmanagement;

import lombok.Data;

import java.io.Serializable;

/**
 * @author ruanzeyang
 * @version RiskWorkInfoRespomse.java, v 0.1 2021-12-08 15:50 ruanzeyang
 */
@Data
public class RiskWorkInfoResponse implements Serializable {

    private static final long serialVersionUID = 6942363921408172039L;

    /**
     * 商户号
     */
    private String merchantId;

    /**
     * 直属代理商编号
     */
    private String directlyAgentId;

    /**
     * 风控工单ID
     */
    private String ticketNumber;

    /**
     * 风控工单创建时间
     */
    private String createTime;

    /**
     * 工单状态;1--待提交 2--审核中; 3--审核未通过；4--审核通过 5--审核终止  0-未知状态
     */
    private Integer ticketStatus;

    /**
     * 风险来源，
     * 1--微信投诉;2--微信违规;3--支付宝违规;
     * 4--云闪付;5--乐刷；6-支付宝告警
     */
    private Integer riskSource;

    /**
     * 风险类型
     */
    private Integer riskType;

    /**
     * 交易类型;1-刷卡/快捷;2-扫码
     */
    private Integer merchantTxnType;

    /**
     * 工单操作类型：1-只能查看；2-（查看和）提交资料
     */
    private String operationType;

    /**
     * 最后处理日期
     */
    private String resolveDeadline;
}