/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

/**
 * 指定支付方式枚举
 *
 * @author zhaoyi
 * @version LimitPayEnum.java, v 0.1 2020-08-03 15:05 zhaoyi
 */
public enum LimitPayEnum {
    UNLIMITED(0, "不限"),
    LIMITED(1, "禁止使用信用卡"),
    ;

    private Integer type;
    private String desc;

    LimitPayEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static LimitPayEnum getByType(Integer type) {
        LimitPayEnum[] valueList = LimitPayEnum.values();
        for (LimitPayEnum v : valueList) {
            if (v.getType().equals(type)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>type</tt>.
     *
     * @return property value of type
     */
    public Integer getType() {
        return type;
    }

    /**
     * Getter method for property <tt>desc</tt>.
     *
     * @return property value of desc
     */
    public String getDesc() {
        return desc;
    }
}
