/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.response;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * @author Xu Jian
 * @version ShopSubbranchMultiReportResponse.java, v 0.1 2021-04-01 13:44 xujian
 */
@Data
public class ShopSubbranchMultiReportResponse implements Serializable {
    private static final long serialVersionUID = 50942325195486608L;

    /**
     * 交易类型
     */
    @JSONField(name = "FChannelType")
    private String FChannelType;

    /**
     * 乐刷商户号
     */
    @JSONField(name = "FMerchantId")
    private String FMerchantId;

    /**
     * 通道商户号
     */
    @JSONField(name = "FChannelId")
    private String FChannelId;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
