/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.settlement;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.settlement.MerchantQueryQuickWithdrawResponse;
import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotBlank;

/**
 * 商户提现实时到账权限查询接口 request
 *
 * @author linzy
 * @version MerchantQueryQuickWithdrawRequest.java, v 0.1 2022-02-18 17:50 linzy
 */
@Data
public class MerchantQueryQuickWithdrawRequest extends LeshuaBizRequest<MerchantQueryQuickWithdrawResponse> {

    private static final long serialVersionUID = 3424832740711397139L;

    /**
     * 乐刷商编
     */
    @NotBlank(message = "乐刷商编不能为空")
    private String merchantId;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<MerchantQueryQuickWithdrawResponse> getResponseClass() {
        return MerchantQueryQuickWithdrawResponse.class;
    }
}
