/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

/**
 * 交易类型枚举
 *
 * @author zhaoyi
 * @version TradeTypeEnum.java, v 0.1 2020-08-03 15:48 zhaoyi
 */
public enum TradeTypeEnum {
    MICROPAY("MICROPAY", "条码支付"),
    NATIVE("NATIVE", "原生扫码支付"),
    JSAPI("JSAPI", "公众号支付、服务窗支付"),
    SMPGPAY("SmPgPay", "小程序支付"),
    JSAPI_QUICK("JSAPIQuick", "简易支付"),
    ;

    private String code;
    private String desc;

    TradeTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static TradeTypeEnum getByType(String code) {
        TradeTypeEnum[] valueList = TradeTypeEnum.values();
        for (TradeTypeEnum v : valueList) {
            if (v.getCode().equalsIgnoreCase(code)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>code</tt>.
     *
     * @return property value of code
     */
    public String getCode() {
        return code;
    }

    /**
     * Getter method for property <tt>desc</tt>.
     *
     * @return property value of desc
     */
    public String getDesc() {
        return desc;
    }
}
