/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.pay;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotBlank;

/**
 * 订单查询request
 *
 * @author zhaoyi
 * @version LeshuaPayQueryRequest.java, v 0.1 2020-07-29 11:50 zhaoyi
 */
@Data
public class LeshuaPayQueryRequest extends LeshuaBasePayRequest {

    private static final long serialVersionUID = 3918011052902443664L;
    /**
     * 接口名
     * 固定值
     */
    private String service = "query_status";

    /**
     * 商户号
     * 由乐刷分配
     */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /**
     * 商户订单号
     * 商户内部订单号，可以包含字母：确保同一个商户下唯一
     */
    private String thirdOrderId;

    /**
     * 乐刷订单号
     * thirdOrderId和leshuaOrderId必填1个，优先使用leshuaOrderId
     */
    private String leshuaOrderId;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
