/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.rate;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * 银联二维码扫码费率
 * 设置的是小于等于1000的费率
 *
 * @author zhaoyi
 * @version UnionScan2Rate.java, v 0.1 2020-07-30 10:03 zhaoyi
 */
@Data
public class UnionScan2Rate implements Serializable {
    private static final long serialVersionUID = 5172658152743862725L;
    /**
     * 次日结算贷记卡费率(刷卡或银联扫码支付必传)
     */
    private FeeUnit t1Credit;

    /**
     * 次日结算借记卡费率(刷卡或银联扫码支付必传)
     */
    private FeeUnit t1Debit;

    /**
     * 次日结算境外卡费率(刷卡支付必传)
     */
    private FeeUnit t1OverSee;

    /**
     * T0结算贷记卡费率
     */
    private FeeUnit t0Credit;

    /**
     * TO结算借记卡费率
     */
    private FeeUnit t0Debit;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
