/**
 * @author: cll
 * @version:1.0
 * @date: 2021-08-03 14:32
 * @descripton:
 */
package com.fshows.leshuapay.sdk.util;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author cll
 * @version HttpClientUtil.java, v 0.1 2021-08-03 14:32 cll
 */
public class HttpClientUtil {
    /**
     * httpClient的get请求方式 使用GetMethod来访问一个URL对应的网页实现步骤： 1.生成一个HttpClient对象并设置相应的参数；
     * 2.生成一个GetMethod对象并设置响应的参数； 3.用HttpClient生成的对象来执行GetMethod生成的Get方法； 4.处理响应状态码；
     * 5.若响应正常，处理HTTP响应内容； 6.释放连接。
     *
     * @param url
     * @param charset
     * @return //
     */
    //  public static String doGet(String url, String charset) {
    //    // 1.生成HttpClient对象并设置参数
    //    HttpClient httpClient = new HttpClient();
    //    // 设置Http连接超时为5秒
    //    httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
    //    // 2.生成GetMethod对象并设置参数
    //    GetMethod getMethod = new GetMethod(url);
    //    // 设置get请求超时为5秒
    //    getMethod.getParams().setParameter(HttpMethodParams.SO_TIMEOUT, 5000);
    //    // 设置请求重试处理，用的是默认的重试处理：请求三次
    //    getMethod
    //        .getParams()
    //        .setParameter(HttpMethodParams.RETRY_HANDLER, new DefaultHttpMethodRetryHandler());
    //    String response = "";
    //    // 3.执行HTTP GET 请求
    //    try {
    //      int statusCode = httpClient.executeMethod(getMethod);
    //      // 4.判断访问的状态码
    //      if (statusCode != HttpStatus.SC_OK) {
    //        System.err.println("请求出错：" + getMethod.getStatusLine());
    //      }
    //      // 5.处理HTTP响应内容
    //      // HTTP响应头部信息，这里简单打印
    //      Header[] headers = getMethod.getResponseHeaders();
    //      for (Header h : headers) {
    //        System.out.println(h.getName() + "---------------" + h.getValue());
    //      }
    //      // 读取HTTP响应内容，这里简单打印网页内容
    //      // 读取为字节数组
    //      byte[] responseBody = getMethod.getResponseBody();
    //      response = new String(responseBody, charset);
    //      System.out.println("-----------response:" + response);
    //      // 读取为InputStream，在网页内容数据量大时候推荐使用
    //      // InputStream response = getMethod.getResponseBodyAsStream();
    //    } catch (HttpException e) {
    //      // 发生致命的异常，可能是协议不对或者返回的内容有问题
    //      System.out.println("请检查输入的URL!");
    //      e.printStackTrace();
    //    } catch (IOException e) {
    //      // 发生网络异常
    //      System.out.println("发生网络异常!");
    //    } finally {
    //      // 6.释放连接
    //      getMethod.releaseConnection();
    //    }
    //    return response;
    //  }

    /**
     * post请求
     *
     * @param url
     * @param json
     * @return
     */
    public static JSONObject doPost(String url, JSONObject json) {
        //    HttpClient httpClient = HttpClients.createDefault();
        //    PostMethod postMethod = new PostMethod(url);
        //
        //    postMethod.addRequestHeader("accept", "*/*");
        //    postMethod.addRequestHeader("connection", "Keep-Alive");
        //    // 设置json格式传送
        //    postMethod.addRequestHeader("Content-Type", "application/json;charset=GBK");
        //    // 必须设置下面这个Header
        //    postMethod.addRequestHeader(
        //        "User-Agent",
        //        "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko)
        // Chrome/58.0.3029.81 Safari/537.36");
        //    // 添加请求参数
        //    postMethod.addParameter("commentId", json.getString("commentId"));
        //
        //    String res = "";
        //    try {
        //      int code = httpClient.execute(postMethod);
        //      if (code == 200) {
        //        res = postMethod.getResponseBodyAsString();
        //        System.out.println(res);
        //      }
        //    } catch (IOException e) {
        //      e.printStackTrace();
        //    }
        //    return res;
        HttpClient client = HttpClients.createDefault();
        // 要调用的接口方法
        url = "https://saas-combine.leshuazf.com/open-api/riskManage/commit-risk-tickets";
        HttpPost post = new HttpPost(url);
        JSONObject jsonObject = null;
        try {
            StringEntity s = new StringEntity(json.toString(), "utf-8"); // 此处为解决传输来的数据变成乱码的问题
            s.setContentEncoding("UTF-8");
            s.setContentType("application/json");

            post.addHeader("content-type", "application/json");
            post.setEntity(s);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); // 设置日期格式
            System.out.println(("请求时间:" + df.format(new Date()))); // new Date()为获取当前系统时间
            System.out.println("请求乐刷参数:" + json.toString());
            HttpResponse res = client.execute(post);
            if (res.getStatusLine().getStatusCode() == 200) { // 此处判断状态是否为200
                String result = EntityUtils.toString(res.getEntity());
                jsonObject = JSONObject.parseObject(result); // 返回json格式：
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return jsonObject;
    }

    public static void main(String[] args) {
        // 提交
        //    JSONObject jsonObject = new JSONObject();
        //    jsonObject.put("appealInfoType", 2);
        //    jsonObject.put("appealMaterial", "{}");
        //    jsonObject.put("merchantAuthenticity", 1);
        //    jsonObject.put("merchantId", "6611914961");
        //    jsonObject.put("riskSource", 5);
        //    jsonObject.put("sourceCode", 2);
        //    jsonObject.put("ticketNumber", "RC2021030809575560089");
        //    jsonObject.put("txnType", 2);
        ////    String key =
        ////        "6611914961&RC2021030809575560089&"
        ////            + jsonObject.get("appealMaterial")
        ////            + "&A7F89ABEF54C91136B9C7CA68C4FB42F";
        //      String key = "6611914961&RC2021030809575560089&{}&B6FED9DCAF22266CFF27FA679F5E9581";
        //    System.out.println(key);
        //    try {
        //      jsonObject.put("sign", Base64.encodeBase64String(BrushMD5.md5(key).getBytes("utf-8")));
        //    } catch (UnsupportedEncodingException e) {
        //      e.printStackTrace();
        //    }
        //    //    jsonObject.put("sign","YTNmYmZlODQ4MTY2NTBjM2JkZDg0NjBiODkzZDA5MDY=");
        //    System.out.println("key is:" + key);
        //    System.out.println(
        //        doPost("http://tcc.taobao.com/cc/json/mobile_tel_segment.htm?tel=13026194071",
        // jsonObject));

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appealInfoType", 1);
        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("videoUrl", "fasfasfasd");
        jsonObject1.put("handheldImg", "fasfasfasd");
        jsonObject1.put("bankCardFront", "fasfasfasd");

        jsonObject1.put("txnTime1", "fasfasfasd");

        jsonObject1.put("txnTime2", "fasfasfasd");

        jsonObject1.put("txnTime3", "fasfasfasd");
        jsonObject1.put("evidenceImg1", "fasfasfasd");
        jsonObject1.put("evidenceImg2", "fasfasfasd");

        jsonObject1.put("evidenceImg3", "fasfasfasd");
        jsonObject1.put("txnAmt1", "fasfasfasd");
        jsonObject1.put("txnAmt2", "fasfasfasd");
        jsonObject1.put("txnAmt3", "fasfasfasd");
        jsonObject1.put("txnAmt3", "fasfasfasd");
        jsonObject1.put("orderId1", "fasfasfasd");
        jsonObject1.put("orderId2", "fasfasfasd");
        jsonObject1.put("orderId3", "fasfasfasd");


        jsonObject.put("appealMaterial", jsonObject1.toJSONString());
        jsonObject.put("agentId", "1071736");
        jsonObject.put("merchantId", "0923013413");
        jsonObject.put("riskSource", 5);
        jsonObject.put("sourceCode", 2);
        jsonObject.put("ticketNumber", "RC2021081211550978364");
        jsonObject.put("txnType", 2);
        jsonObject.put("merchantAuthenticity", 1);
        String key =
                "0923013413&RC2021081211550978364&"
                        + jsonObject.get("appealMaterial")
                        + "&B6FED9DCAF22266CFF27FA679F5E9581";
//        String key = "1071736&B6FED9DCAF22266CFF27FA679F5E9581";
        System.out.println(key);
        try {
            jsonObject.put("sign", Base64.encodeBase64String(BrushMD5.md5(key).getBytes("utf-8")));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        //    jsonObject.put("sign","YTNmYmZlODQ4MTY2NTBjM2JkZDg0NjBiODkzZDA5MDY=");
        System.out.println("key is:" + key);
        System.out.println(
                doPost("http://tcc.taobao.com/cc/json/mobile_tel_segment.htm?tel=13026194071", jsonObject));
    }

}
