/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.leshuapay.sdk.client.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.fshows.leshuapay.sdk.client.UploadAttachClient;
import com.fshows.leshuapay.sdk.exception.LeshuaException;
import com.fshows.leshuapay.sdk.request.UploadAttachRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;
import com.fshows.leshuapay.sdk.response.UploadAttachResponse;
import com.fshows.leshuapay.sdk.util.BrushMD5;
import com.fshows.leshuapay.sdk.util.DateUtil;
import com.fshows.leshuapay.sdk.util.FsHttpUtil;
import com.fshows.leshuapay.sdk.util.ReqSerialNoUtil;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadAttachClientImpl
implements UploadAttachClient {
    private static final Logger log = LoggerFactory.getLogger(UploadAttachClientImpl.class);
    public static final String IMG_FILE_SAVE_TEMP_DIR = SystemUtils.getUserHome() + File.separator + "files" + File.separator + "upload" + File.separator + "leshua" + File.separator + "temp" + File.separator;
    private static final String SUCCESS = "000000";
    private String serverUrl;
    private String agentId;
    private String privateKey;

    public UploadAttachClientImpl(String serverUrl, String agentId, String privateKey) {
        this.serverUrl = serverUrl;
        this.agentId = agentId;
        this.privateKey = privateKey;
    }

    @Override
    public UploadAttachResponse upload(String filePath) throws Exception {
        return this.upload(this.serverUrl, this.agentId, this.privateKey, filePath);
    }

    @Override
    public UploadAttachResponse upload(String serverUrl, String agentId, String privateKey, String filePath) throws Exception {
        if (filePath == null) {
            throw new IllegalArgumentException("\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UploadAttachResponse response = new UploadAttachResponse();
        String localFilePath = this.downloadFile(filePath);
        if ("".equals(localFilePath)) {
            log.error("\u56fe\u7247\u4e0b\u8f7d\u5931\u8d25,filePath={}", (Object)filePath);
            return response;
        }
        File file = new File(localFilePath);
        String fileMD5 = DigestUtils.md5Hex((byte[])FileUtils.readFileToByteArray((File)file));
        UploadAttachRequest request = new UploadAttachRequest();
        request.setFileMD5(fileMD5);
        HashMap requestMap = Maps.newHashMap();
        this.getRequestMap(requestMap, privateKey, request, agentId);
        log.info("\u4e50\u5237\u5546\u6237\u56fe\u7247\u4e0a\u4f20\u63a5\u53e3\u8bf7\u6c42\u4e50\u5237\u5165\u53c2 >> upload >> url = {}, params = {}", (Object)serverUrl, (Object)JSON.toJSONString((Object)request));
        long startTime = System.currentTimeMillis();
        File uploadFile = new File(localFilePath);
        String result = FsHttpUtil.postMedia(serverUrl, requestMap, uploadFile);
        log.info("\u4e50\u5237\u5546\u6237\u56fe\u7247\u4e0a\u4f20\u63a5\u53e3\u8bf7\u6c42\u4e50\u5237\u51fa\u53c2 >> upload >> url = {}, params = {}, result = {}, runTimes = {}", new Object[]{serverUrl, JSON.toJSONString((Object)request), result, System.currentTimeMillis() - startTime});
        if (result == null) {
            return response;
        }
        LeshuaBaseResponse baseResponse = (LeshuaBaseResponse)JSON.parseObject((String)result, LeshuaBaseResponse.class);
        if (SUCCESS.equals(baseResponse.getRespCode()) && baseResponse.getData() != null) {
            response.setPhotoUrl(JSON.parseObject((String)baseResponse.getData().toString()).getString("photoUrl"));
        }
        if (file.exists()) {
            file.delete();
        }
        return response;
    }

    public void getRequestMap(Map<String, String> requestMap, String privateKey, UploadAttachRequest request, String agentId) throws LeshuaException {
        String waitSign = "lepos" + privateKey + JSON.toJSONString((Object)request);
        try {
            String sign = Base64.encodeBase64String((byte[])BrushMD5.md5(waitSign).getBytes("utf-8"));
            requestMap.put("agentId", agentId);
            requestMap.put("version", "2.0");
            requestMap.put("reqSerialNo", ReqSerialNoUtil.getReqSerialNo());
            requestMap.put("sign", sign);
            requestMap.put("data", JSON.toJSONString((Object)request));
        }
        catch (UnsupportedEncodingException e) {
            log.info("\u7b7e\u540d\u5f02\u5e38,e={}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw new LeshuaException("\u7b7e\u540d\u5f02\u5e38", e);
        }
    }

    private String downloadFile(String picPath) throws Exception {
        String savePath = IMG_FILE_SAVE_TEMP_DIR + DateUtil.getNowDateStr();
        String filePath = new URI(picPath).getPath();
        String substring = filePath.substring(filePath.lastIndexOf(".") - 1);
        String fileName = RandomStringUtils.randomAlphanumeric((int)10) + substring;
        String targetFilePath = savePath + File.separator + fileName;
        log.info("UploadAttachClientImpl >> downloadFile,targetFilePath={}", (Object)targetFilePath);
        HttpUtil.downloadFile((String)picPath, (String)targetFilePath);
        if ("".equals(fileName)) {
            return "";
        }
        return targetFilePath;
    }

    private UploadAttachClientImpl() {
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadAttachClientImpl)) {
            return false;
        }
        UploadAttachClientImpl other = (UploadAttachClientImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serverUrl = this.getServerUrl();
        String other$serverUrl = other.getServerUrl();
        if (this$serverUrl == null ? other$serverUrl != null : !this$serverUrl.equals(other$serverUrl)) {
            return false;
        }
        String this$agentId = this.getAgentId();
        String other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !this$agentId.equals(other$agentId)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        return !(this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UploadAttachClientImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serverUrl = this.getServerUrl();
        result = result * 59 + ($serverUrl == null ? 43 : $serverUrl.hashCode());
        String $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : $agentId.hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        return result;
    }

    public String toString() {
        return "UploadAttachClientImpl(serverUrl=" + this.getServerUrl() + ", agentId=" + this.getAgentId() + ", privateKey=" + this.getPrivateKey() + ")";
    }
}

