/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.client;

import com.fshows.leshuapay.sdk.response.UploadFileResponse;

/**
 * 乐刷文件上传接口（视频转zip上传乐刷）
 *
 * @author ruanzeyang
 * @version UploadFileClient.java, v 0.1 2021-12-23 11:54 ruanzeyang
 */
public interface UploadFileClient {

    /**
     * 发起文件上传接口
     *
     * @param filePath
     * @return
     * @throws Exception
     */
    UploadFileResponse upload(String filePath) throws Exception;

    /**
     * 发起文件上传接口
     *
     * @param serverUrl
     * @param agentId
     * @param privateKey
     * @param filePath
     * @return
     * @throws Exception
     */
    UploadFileResponse upload(String serverUrl, String agentId, String privateKey, String filePath) throws Exception;
}