/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.leshuapay.sdk.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fshows.leshuapay.sdk.client.LeshuaRiskClient;
import com.fshows.leshuapay.sdk.enums.RiskApiEnum;
import com.fshows.leshuapay.sdk.exception.LeshuaException;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;
import com.fshows.leshuapay.sdk.util.ValidateUtil;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeshuaRiskClientImpl
implements LeshuaRiskClient {
    private static final Logger log = LoggerFactory.getLogger(LeshuaRiskClientImpl.class);
    private static final int CONNECTION_REQUEST_TIMEOUT = 10000;
    private static final int SOCKET_TIMEOUT = 10000;
    private static final int CONNECT_TIMEOUT = 10000;
    private static CloseableHttpClient httpclient = HttpClients.createDefault();
    private String serverUrl;
    private String agentId;
    private String privateKey;
    private Integer timeout;

    public LeshuaRiskClientImpl(String serverUrl, String agentId, String privateKey, Integer timeout) {
        this.serverUrl = serverUrl;
        this.agentId = agentId;
        this.privateKey = privateKey;
        this.timeout = timeout;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> LeshuaBaseResponse<T> execute(LeshuaBizRequest<T> request, RiskApiEnum riskApiEnum, String url, Integer timeout) throws LeshuaException {
        LeshuaBaseResponse<Object> leshuaBaseResponse;
        ValidateUtil.validateWithThrow(request, new Class[0]);
        HttpPost httpPost = new HttpPost(this.serverUrl + url);
        request = riskApiEnum.getRiskApiSign().doSign(request, this.privateKey, this.agentId);
        StringEntity stringEntity = new StringEntity(JSON.toJSONString((Object)request), ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)stringEntity);
        CloseableHttpResponse httpResponse = null;
        HttpEntity resEntity = null;
        try {
            log.info("\u8bf7\u6c42\u4e50\u5237\u63a5\u53e3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)request));
            httpResponse = httpclient.execute((HttpUriRequest)httpPost);
            resEntity = httpResponse.getEntity();
            String responseStr = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
            LeshuaBaseResponse<Object> response = new LeshuaBaseResponse<Object>();
            JSONObject jsonObject = JSON.parseObject((String)responseStr);
            response.setRespCode(jsonObject.getString("error_code"));
            response.setRespMsg(jsonObject.getString("error_msg"));
            response.setData(JSON.parseObject((String)jsonObject.getString("data"), request.getResponseClass()));
            log.info("\u8bf7\u6c42\u4e50\u5237\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}", response);
            leshuaBaseResponse = response;
        }
        catch (Exception e) {
            try {
                throw new LeshuaException("\u8c03\u7528\u5931\u8d25", e);
            }
            catch (Throwable throwable) {
                try {
                    EntityUtils.consume(resEntity);
                }
                catch (IOException e2) {
                    log.error("\u91ca\u653eHttpEntity\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e2.getMessage(), (Throwable)e2);
                }
                if (httpResponse == null) throw throwable;
                try {
                    httpResponse.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    log.error("\u5173\u95edHttpResponse\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e3.getMessage(), (Throwable)e3);
                }
                throw throwable;
            }
        }
        try {
            EntityUtils.consume((HttpEntity)resEntity);
        }
        catch (IOException e) {
            log.error("\u91ca\u653eHttpEntity\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
        }
        if (httpResponse == null) return leshuaBaseResponse;
        try {
            httpResponse.close();
            return leshuaBaseResponse;
        }
        catch (IOException e) {
            log.error("\u5173\u95edHttpResponse\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
        }
        return leshuaBaseResponse;
    }

    private LeshuaRiskClientImpl() {
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeshuaRiskClientImpl)) {
            return false;
        }
        LeshuaRiskClientImpl other = (LeshuaRiskClientImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serverUrl = this.getServerUrl();
        String other$serverUrl = other.getServerUrl();
        if (this$serverUrl == null ? other$serverUrl != null : !this$serverUrl.equals(other$serverUrl)) {
            return false;
        }
        String this$agentId = this.getAgentId();
        String other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !this$agentId.equals(other$agentId)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        Integer this$timeout = this.getTimeout();
        Integer other$timeout = other.getTimeout();
        return !(this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LeshuaRiskClientImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serverUrl = this.getServerUrl();
        result = result * 59 + ($serverUrl == null ? 43 : $serverUrl.hashCode());
        String $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : $agentId.hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        Integer $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        return result;
    }

    public String toString() {
        return "LeshuaRiskClientImpl(serverUrl=" + this.getServerUrl() + ", agentId=" + this.getAgentId() + ", privateKey=" + this.getPrivateKey() + ", timeout=" + this.getTimeout() + ")";
    }
}

