/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.share;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.share.ApplyResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 分账确认-单次分账（分账确认请调用多次分账接口）
 *
 * @author linzy
 * @version ApplyRequest.java, v 0.1 2021-05-06 11:50 linzy
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ApplyRequest extends LeshuaBizRequest<ApplyResponse> {

    /**
     * 商户号
     * 由乐刷分配
     */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /**
     * 第三方分账单号
     */
    private String thirdRoyaltyId;

    /**
     * 第三方订单号
     */
    private String thirdOrderId;

    /**
     * 乐刷订单号
     */
    private String leshuaOrderId;

    /**
     * 分账备注
     */
    private String remark;

    /**
     * 分账的详细内容
     */
    private List<ShareDetail> shareDetail;

    @Override
    public Class<ApplyResponse> getResponseClass() {
        return ApplyResponse.class;
    }
}
