/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.pay;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 查询授权openid
 * @author xiaotian
 * @version LeshuaQueryOpenIdRequest.java, v 0.1 2020-07-29 16:40
 */
@Data
public class LeshuaQueryOpenIdRequest extends LeshuaBasePayRequest{

    /**
     * 接口名
     */
    private String service = "query_openid";

    /**
     * 乐刷分配的商户号
     **/
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /**
     * 授权码 微信授权码
     */
    @NotBlank(message = "authCode不能为空")
    private String authCode;

    /**
     * 微信公众号ID
     */
    @NotBlank(message = "appid不能为空")
    private String appid;

}

