
/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.settlement;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 法人信息
 *
 * @author zhaoyi
 * @version legalPerson.java, v 0.1 2020-07-27 12:03 zhaoyi
 */
@Data
public class LegalPerson implements Serializable {
    private static final long serialVersionUID = 821079015844156778L;

    /**
     * 法人姓名
     */
    @NotBlank(message = "法人姓名不能为空")
    @Length(min = 2, max = 20, message = "法人姓名超长")
    private String legalName;

    /**
     * 证件类型：
     * 1-身份证；(默认)
     * 2-港澳台通行证；
     * 3-台湾身份证；
     * 4-香港身份证；
     * 5-澳门身份证；
     * 6-护照；
     * 7-居住证；
     * 9-其它法定文件
     */
    private Integer credentialType;

    /**
     * 证件号码
     */
    @NotBlank(message = "证件号码不能为空")
    @Length(max = 18, message = "证件号码超长")
    private String idCardNo;

    /**
     * 法人身份证正面图片地址
     */
    @NotBlank(message = "法人身份证正面图片地址不能为空")
    private String idcardFrontPic;

    /**
     * 法人身份证反面图片地址
     */
    @NotBlank(message = "法人身份证反面图片地址不能为空")
    private String idcardBackPic;

    /**
     * 手持身份证照
     */
    private String idcardHandPic;

    /**
     * 证件有效期开始日期
     */
    @NotBlank(message = "证件有效期开始日期不能为空")
    private String idCardStart;

    /**
     * 证件有效期结束日期格式：2015-09-22，永久有效:长期
     */
    @NotBlank(message = "证件有效期结束日期不能为空")
    private String idCardEnd;
}
