package com.fshows.leshuapay.sdk.enums;

import com.fshows.leshuapay.sdk.util.risksign.LeshuaRiskSign;
import com.fshows.leshuapay.sdk.util.risksign.RiskCommitSign;
import com.fshows.leshuapay.sdk.util.risksign.RiskDetailSign;
import com.fshows.leshuapay.sdk.util.risksign.RiskListSign;

/**
 * @author chenll
 * @version RiskApiEnum.java, v 0.1 2021-08-12 17:43 chenll 风控签名规则枚举
 */
public enum RiskApiEnum {
  RISK_COMMIT("RISK_COMMIT", new RiskCommitSign()),
  RISK_LIST("RISK_LIST", new RiskDetailSign()),
  RISK_DETAIL("RISK_DETAIL", new RiskListSign()),
  ;

  private String name;
  private LeshuaRiskSign riskApiSign;

  RiskApiEnum(String name, LeshuaRiskSign riskApiSign) {
    this.name = name;
    this.riskApiSign = riskApiSign;
  }

  public String getName() {
    return name;
  }

  public RiskApiEnum setName(String name) {
    this.name = name;
    return this;
  }

  public LeshuaRiskSign getRiskApiSign() {
    return riskApiSign;
  }

  public RiskApiEnum setRiskApiSign(LeshuaRiskSign riskApiSign) {
    this.riskApiSign = riskApiSign;
    return this;
  }
}
