/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.share;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 分账的详细内容
 *
 * @author linzy
 * @version ShareDetail.java, v 0.1 2021-05-06 14:50 linzy
 */
@Data
public class ShareDetail implements Serializable {

    private static final long serialVersionUID = -3366304297346709081L;

    /**
     * 接收分账商户号
     */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /**
     * 金额，单位：分
     */
    private BigDecimal amount;

    /**
     * 详情备注（与上面的remark不是同一个）
     */
    private String remark;
}
