/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.merchant;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.ShopSubbranchMultiReportResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * @author Xu Jian
 * @version ShopSubbranchMultiReportRequest.java, v 0.1 2021-04-01 13:42 xujian
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ShopSubbranchMultiReportRequest extends LeshuaBizRequest<ShopSubbranchMultiReportResponse> {

    /**
     * 乐刷商户号
     */
    @NotBlank(message = "乐刷商户号必传")
    private String FMerchantId;

    /**
     * 通道类型
     */
    @NotBlank(message = "交易类型必传")
    private String FPayType;

    /**
     * 交易类型
     */
    private String FChannelType;

    /**
     * 上报主体
     */
    @NotBlank(message = "上报主体")
    private String FReportSubject;

    /**
     * 上报商户简称
     */
    private String FReportShortName;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<ShopSubbranchMultiReportResponse> getResponseClass() {
        return ShopSubbranchMultiReportResponse.class;
    }
}
