/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.response.share;

import lombok.Data;

import java.io.Serializable;

/**
 * 分账撤销
 *
 * @author linzy
 * @version CancelResponse.java, v 0.1 2021-05-06 11:50 linzy
 */
@Data
public class CancelResponse implements Serializable {

    private static final long serialVersionUID = -1844939304655530869L;

    /**
     * 乐刷商户号
     */
    private String merchantId;

    /**
     * 乐刷分账订单号
     */
    private String leshuaRoyaltyId;

    /**
     * 第三方分账订单号
     */
    private String thirdRoyaltyId;

    /**
     * 交易订单号
     */
    private String leshuaOrderId;

    /**
     * 分账订单状态，见下方说明
     * 0分账初始
     * 1分账成功
     * 2分账失败
     * 3分账撤销
     */
    private String royaltyStatus;
}
