/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.response.merchant.settlement;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * 商户信息查询-accountInfo
 *
 * @author zhaoyi
 * @version MerchantAccountInfo.java, v 0.1 2020-07-30 12:15 zhaoyi
 */
@Data
public class MerchantAccountInfo implements Serializable {


    private static final long serialVersionUID = -416447551370304605L;
    /**
     * 开户行名称
     */
    private String branch;

    /**
     * 开户名
     */
    private String holder;

    /**
     * 卡号
     */
    private String bankCardNo;

    /**
     * 加密银行卡号
     */
    private String bankCardMd5;

    /**
     * 提现类型
     * 1-自动提现，2-手动提现。
     */
    private String withDrawType;
}
