/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.util;

import java.text.SimpleDateFormat;


/**
 * 请求流水号工具类
 *
 * @author zhaoyi
 * @version ReqSerialNoUtil.java, v 0.1 2020-07-23 10:47 zhaoyi
 */
public class ReqSerialNoUtil {

    /**
     * 最大万位数
     */
    public static final int MAX_TEN_THOUSAND_INT = 99999;

    private static ThreadLocal<SimpleDateFormat> sdf = new ThreadLocal<SimpleDateFormat>() {
        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(StringPool.DEFAULT_TIMESTAMP_MILLISECOND_FORMAT);
        }
    };

    private static volatile int reqSerialNo = 10000;

    public static String getReqSerialNo() {
        return getReqSerialNo(System.currentTimeMillis());
    }

    public static String getReqSerialNo(long timeMillis) {
        reqSerialNo++;
        if (reqSerialNo > MAX_TEN_THOUSAND_INT) {
            reqSerialNo = 10000;
        }
        return sdf.get().format(timeMillis) + reqSerialNo;
    }


    public static void main(String[] args) {
        System.out.println(ReqSerialNoUtil.getReqSerialNo());
    }

}
