/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.response.merchant;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * 银联小微商户上报信息
 *
 * @author zhaoyi
 * @version UnionscanReportInfo.java, v 0.1 2020-07-29 15:25 zhaoyi
 */
@Data
public class UnionscanReportInfo implements Serializable {

    private static final long serialVersionUID = -7689905752090371399L;
    /**
     * 银联小微商户号（上报失败则为空）
     */
    private String subMchId;

    /**
     * 上报失败时的失败原因
     */
    private String msg;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }


}
