/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

/**
 * 证件类型枚举
 *
 * @author zhaoyi
 * @version CredentialTypeEnum.java, v 0.1 2020-08-03 10:56 zhaoyi
 */
public enum CredentialTypeEnum {
    ID_CARD(1, "身份证"),
    HONGKONG_MACAO_TAIWAN_PASS(2, "港澳台通行证"),
    TAIWAN_ID_CARD(3, "台湾身份证"),
    HONGKONG_ID_CARD(4, "香港身份证"),
    MACAO_ID_CARD(5, "澳门身份证"),
    PASSPORT(6, "护照"),
    RESIDENCE_PERMIT(7, "居住证"),
    OTHER_STATUTORY_INSTRUMENTS(9, "其它法定文件"),
    ;

    private Integer type;
    private String desc;

    CredentialTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static CredentialTypeEnum getByType(Integer type) {
        CredentialTypeEnum[] valueList = CredentialTypeEnum.values();
        for (CredentialTypeEnum v : valueList) {
            if (v.getType().equals(type)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>type</tt>.
     *
     * @return property value of type
     */
    public Integer getType() {
        return type;
    }

    /**
     * Getter method for property <tt>desc</tt>.
     *
     * @return property value of desc
     */
    public String getDesc() {
        return desc;
    }
}
