/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.leshuapay.sdk.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fshows.leshuapay.sdk.util.UpperCaseNameCoder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeshuaUtils {
    private static final Logger log = LoggerFactory.getLogger(LeshuaUtils.class);
    private static final String XML = "xml";
    private static Pattern UNDERLINE_PATTERN = Pattern.compile("[A-Z]");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readInput(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int len = 0;
        byte[] buffer = new byte[1024];
        try {
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            out.close();
            in.close();
        }
        return out.toByteArray();
    }

    public static String inputStreamToString(InputStream is) throws IOException {
        int i;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((i = is.read()) != -1) {
            baos.write(i);
        }
        return baos.toString("utf-8");
    }

    public static InputStream getStringStream(String sInputString) throws UnsupportedEncodingException {
        ByteArrayInputStream tInputStringStream = null;
        if (sInputString != null && !sInputString.trim().equals("")) {
            tInputStringStream = new ByteArrayInputStream(sInputString.getBytes("utf-8"));
        }
        return tInputStringStream;
    }

    public static <Res> Res getObjectFromXML(String xml, Class<Res> tClass, String alias) {
        XStream xStreamForResponseData = new XStream((HierarchicalStreamDriver)new DomDriver("utf-8", (NameCoder)new UpperCaseNameCoder()));
        XStream.setupDefaultSecurity((XStream)xStreamForResponseData);
        xStreamForResponseData.alias(alias, tClass);
        xStreamForResponseData.allowTypes(new Class[]{tClass});
        xStreamForResponseData.ignoreUnknownElements();
        Object object = xStreamForResponseData.fromXML(xml);
        return (Res)JSON.parseObject((String)JSONObject.toJSONString((Object)object), tClass);
    }

    public static Map<String, String> toMap(Object obj) {
        Field[] fields;
        ConcurrentSkipListMap<String, String> map = new ConcurrentSkipListMap<String, String>();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            try {
                Object val;
                field.setAccessible(true);
                if (Modifier.isStatic(field.getModifiers()) || (val = field.get(obj)) == null) continue;
                String key = field.getName();
                map.put(LeshuaUtils.camelToUnderline(key), String.valueOf(val));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return map;
    }

    public static String calcExpireTime(Date now, String expireInMinutes, SimpleDateFormat dateFormat) {
        return dateFormat.format(now.getTime() + Long.parseLong(expireInMinutes) * 60L * 1000L);
    }

    public static String camelToUnderline(String str) {
        Matcher matcher = UNDERLINE_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

