/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.leshuapay.sdk.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fshows.leshuapay.sdk.client.LeshuaPaymentClient;
import com.fshows.leshuapay.sdk.enums.LeshuaSettlementApiEnum;
import com.fshows.leshuapay.sdk.exception.LeshuaException;
import com.fshows.leshuapay.sdk.request.merchant.settlement.MerchantSettlementOrderRequest;
import com.fshows.leshuapay.sdk.response.merchant.settlement.MerchantSettlementOrderBaseResponse;
import com.fshows.leshuapay.sdk.response.merchant.settlement.MerchantSettlementOrderResponse;
import com.fshows.leshuapay.sdk.util.FsHttpUtil;
import com.fshows.leshuapay.sdk.util.LeshuaSignature;
import com.fshows.leshuapay.sdk.util.ReqSerialNoUtil;
import com.fshows.leshuapay.sdk.util.SignUtil;
import com.fshows.leshuapay.sdk.util.ValidateUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeshuaPaymentClientImpl
implements LeshuaPaymentClient {
    private static final Logger log = LoggerFactory.getLogger(LeshuaPaymentClientImpl.class);
    private String agentId;
    private String serverUrl;
    private String privateKey;
    private static final int CONNECTION_REQUEST_TIMEOUT = 10000;
    private static final int SOCKET_TIMEOUT = 10000;
    private static final int CONNECT_TIMEOUT = 10000;
    private static CloseableHttpClient httpclient = HttpClients.createDefault();
    private Integer timeout;

    public LeshuaPaymentClientImpl(String agentId, String serverUrl, String privateKey) {
        this.agentId = agentId;
        this.serverUrl = serverUrl;
        this.privateKey = privateKey;
    }

    public LeshuaPaymentClientImpl(String agentId, String serverUrl, String privateKey, Integer timeout) {
        this(agentId, serverUrl, privateKey);
        this.timeout = timeout;
    }

    @Override
    public MerchantSettlementOrderResponse querySettlementOrder(MerchantSettlementOrderRequest request, LeshuaSettlementApiEnum apiEnum) {
        ValidateUtil.validateWithThrow(request, new Class[0]);
        MerchantSettlementOrderResponse response = new MerchantSettlementOrderResponse();
        ConcurrentSkipListMap<String, String> requestMap = new ConcurrentSkipListMap<String, String>();
        requestMap.put("agentId", this.agentId);
        requestMap.put("billId", request.getBillId());
        requestMap.put("type", request.getType());
        String sign = LeshuaSignature.getMD5Sign(requestMap, null, this.privateKey);
        if (sign != null) {
            sign = sign.toLowerCase();
        }
        requestMap.put("sign", sign);
        try {
            String url = this.serverUrl + apiEnum.getValue();
            String responseStr = FsHttpUtil.post(url, requestMap);
            log.info("querySettlementOrder >> \u4e50\u5237\u7ed3\u7b97\u5355\u67e5\u8be2 >> url={},request={},response={}", new Object[]{url, JSONObject.toJSONString(requestMap), responseStr});
            JSONObject jsonObject = JSON.parseObject((String)responseStr);
            response = (MerchantSettlementOrderResponse)jsonObject.toJavaObject(MerchantSettlementOrderResponse.class);
            response.setErrorCode(jsonObject.getString("error_code"));
            response.setErrorMsg(jsonObject.getString("error_msg"));
            return response;
        }
        catch (IOException e) {
            log.error("\u6267\u884chttp\u8bf7\u6c42\u5f02\u5e38,e={}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return response;
        }
    }

    @Override
    public <Req, Res> MerchantSettlementOrderBaseResponse<Res> execute(Req request, LeshuaSettlementApiEnum apiEnum, Class<Res> resClass) throws LeshuaException {
        ValidateUtil.validateWithThrow(request, new Class[0]);
        MerchantSettlementOrderBaseResponse response = new MerchantSettlementOrderBaseResponse();
        String url = this.serverUrl + apiEnum.getValue();
        String responseStr = this.executeHttp(JSON.toJSONString(request), url);
        JSONObject jsonObject = JSON.parseObject((String)responseStr);
        response.setErrorMsg(jsonObject.getString("error_msg"));
        response.setPageNo(jsonObject.getInteger("pageNo"));
        response.setPageSize(jsonObject.getInteger("pageSize"));
        response.setErrorCode(jsonObject.getString("error_code"));
        response.setTotalCount(jsonObject.getInteger("totalCount"));
        JSONObject dataJson = jsonObject.getJSONObject("data");
        JSONArray jsonArray = dataJson.getJSONArray("list");
        List orders = jsonArray.toJavaList(resClass);
        response.setList(orders);
        return response;
    }

    private String executeHttp(String request, String url) throws LeshuaException {
        String sign = SignUtil.getSettlementOrderSign(request, this.privateKey);
        RequestConfig requestConfig = null;
        requestConfig = this.timeout == null || this.timeout <= 0 ? RequestConfig.custom().setConnectionRequestTimeout(10000).setSocketTimeout(10000).setConnectTimeout(10000).build() : RequestConfig.custom().setConnectionRequestTimeout(this.timeout.intValue()).setSocketTimeout(this.timeout.intValue()).setConnectTimeout(this.timeout.intValue()).build();
        HttpPost httppost = new HttpPost(url);
        httppost.setConfig(requestConfig);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        multipartEntityBuilder.setCharset(Charset.forName("utf-8"));
        String reqSerialNo = ReqSerialNoUtil.getReqSerialNo();
        multipartEntityBuilder.addPart("agentId", (ContentBody)new StringBody(this.agentId, ContentType.APPLICATION_JSON));
        multipartEntityBuilder.addPart("version", (ContentBody)new StringBody("2.0", ContentType.APPLICATION_JSON));
        multipartEntityBuilder.addPart("reqSerialNo", (ContentBody)new StringBody(reqSerialNo, ContentType.APPLICATION_JSON));
        multipartEntityBuilder.addPart("data", (ContentBody)new StringBody(request, ContentType.APPLICATION_JSON));
        multipartEntityBuilder.addPart("sign", (ContentBody)new StringBody(sign, ContentType.APPLICATION_JSON));
        HttpEntity reqEntity = multipartEntityBuilder.build();
        httppost.setEntity(reqEntity);
        try {
            CloseableHttpResponse httpResponse = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity resEntity = httpResponse.getEntity();
            String responseStr = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
            log.info("\u8bf7\u6c42\u4e50\u5237\u63a5\u53e3 >> url={},request={},response={}", new Object[]{url, EntityUtils.toString((HttpEntity)reqEntity, (String)"utf-8"), responseStr});
            EntityUtils.consume((HttpEntity)resEntity);
            httpResponse.close();
            return responseStr;
        }
        catch (Exception e) {
            throw new LeshuaException("\u8c03\u7528\u5931\u8d25", e);
        }
    }

    private LeshuaPaymentClientImpl() {
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeshuaPaymentClientImpl)) {
            return false;
        }
        LeshuaPaymentClientImpl other = (LeshuaPaymentClientImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$agentId = this.getAgentId();
        String other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !this$agentId.equals(other$agentId)) {
            return false;
        }
        String this$serverUrl = this.getServerUrl();
        String other$serverUrl = other.getServerUrl();
        if (this$serverUrl == null ? other$serverUrl != null : !this$serverUrl.equals(other$serverUrl)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        Integer this$timeout = this.getTimeout();
        Integer other$timeout = other.getTimeout();
        return !(this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LeshuaPaymentClientImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : $agentId.hashCode());
        String $serverUrl = this.getServerUrl();
        result = result * 59 + ($serverUrl == null ? 43 : $serverUrl.hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        Integer $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        return result;
    }

    public String toString() {
        return "LeshuaPaymentClientImpl(agentId=" + this.getAgentId() + ", serverUrl=" + this.getServerUrl() + ", privateKey=" + this.getPrivateKey() + ", timeout=" + this.getTimeout() + ")";
    }
}

