/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

/**
 * 结算对象枚举
 *
 * @author zhaoyi
 * @version SettleToEnum.java, v 0.1 2020-08-03 10:56 zhaoyi
 */
public enum SettleToEnum {
    INDEPENDENT_SETTLEMENT(0, "独立结算"),
    CONSOLIDATED_SETTLEMENT_TO_MAIN_STORE(1, "合并结算至总店"),
    ;

    private Integer type;
    private String desc;

    SettleToEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static SettleToEnum getByType(Integer type) {
        SettleToEnum[] valueList = SettleToEnum.values();
        for (SettleToEnum v : valueList) {
            if (v.getType().equals(type)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>type</tt>.
     *
     * @return property value of type
     */
    public Integer getType() {
        return type;
    }

    /**
     * Getter method for property <tt>desc</tt>.
     *
     * @return property value of desc
     */
    public String getDesc() {
        return desc;
    }
}
