/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.response.merchant.settlement;

import lombok.Data;

import java.io.Serializable;

/**
 * 商户指定日期打款情况response
 *
 * @author zhaoyi
 * @version MerchantSettlementDateOrderResponse.java, v 0.1 2020-07-31 14:50 zhaoyi
 */
@Data
public class MerchantSettlementDateOrderResponse implements Serializable {

    private static final long serialVersionUID = -8503291110507136118L;
    /**
     * 单号
     */
    private String billId;

    /**
     * 创建时间
     */
    private String createTime;

    /**
     * 商户号
     */
    private String merchantId;

    /**
     * 应付金额（单位：1分）
     */
    private Integer planAmount;

    /**
     * 止付金额（单位：1分）
     */
    private Integer suspendAmount;

    /**
     * 实付金额（单位：1分）
     */
    private Integer realAmount;

    /**
     * 状态：
     * -1：打款失败； 0：打款中； 1：打款成功； 2：打款退票； 3：冻结出款；
     */
    private Integer state;

    /**
     * 失败原因
     */
    private String failReason;

    /**
     * 备注：
     * T1打款退票会重新生成一条打款单，财务会根据新生成打款单打款，此时通知时则通过remark字段来关联上次的打款单号，如果再次发生退票，则再重新打款，remark每次只关联上一笔打款单号
     */
    private String remark;

    /**
     * 打款单是否是重新生成的；0：否 1：是 （T0无该字段）
     */
    private String recreateFlag;

    /**
     * 结算类型（D1,D0）
     */
    private String settleType;

    /**
     * 结算日期
     */
    private String settleDate;

    /**
     * 非终态：“此类打款单打款成功仅代表转出成功，不等于最终到账成功。”终态：“此类打款单打款成功，即最终到账成功
     */
    private String tag;


    /**
     * 打款单更新时间
     */
    private String bankretTime;

    /**
     * 开户账号
     */
    private String bankAccount;

    /**
     * 开户名
     */
    private String bankHolder;

}
