/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

/**
 * 小微类型枚举
 *
 * @author zhaoyi
 * @version MicroBizTypeEnum.java, v 0.1 2020-08-03 14:46 zhaoyi
 */
public enum MicroBizTypeEnum {
    MICRO_TYPE_STORE("MICRO_TYPE_STORE", "门店场所"),
    MICRO_TYPE_MOBILE("MICRO_TYPE_MOBILE", "流动经营/便民服务"),
    PASSED("MICRO_TYPE_ONLINE", "线上商品/服务交易"),
    ;

    private String code;
    private String desc;

    MicroBizTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static MicroBizTypeEnum getByType(String code) {
        MicroBizTypeEnum[] valueList = MicroBizTypeEnum.values();
        for (MicroBizTypeEnum v : valueList) {
            if (v.getCode().equalsIgnoreCase(code)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>code</tt>.
     *
     * @return property value of code
     */
    public String getCode() {
        return code;
    }

    /**
     * Getter method for property <tt>desc</tt>.
     *
     * @return property value of desc
     */
    public String getDesc() {
        return desc;
    }
}
