/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.settlement;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 商户指定日期打款情况request
 *
 * @author zhaoyi
 * @version MerchantSettlementDateOrderRequest.java, v 0.1 2020-07-31 14:50 zhaoyi
 */
@Data
public class MerchantSettlementDateOrderRequest implements Serializable {

    private static final long serialVersionUID = 2922880986859155876L;

    /**
     * 商户号
     */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /**
     * 打款单的创建日期 （创建时间是交易时间的下一天）
     */
    @NotBlank(message = "date不能为空")
    private String date;

    /**
     * 类型：D0、D1、Withdraw
     */
    @NotBlank(message = "type不能为空")
    private String type;

    /**
     * 打款状态: -1：打款失败; 0:打款中;1:打款成功; 2:打款退票;3:冻结出款;4：全部
     */
    @NotNull(message = "state不能为空")
    private Integer state;

    /**
     * 页码(页码超出总页数后返回第一页)，每页默认20条数据
     */
    @NotNull(message = "pageNo不能为空")
    private Integer pageNo;
}
