/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.merchant.MerchantSubMchQueryResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 微信/支付宝/银联商户号查询request
 *
 * @author zhaoyi
 * @version MerchantSubMchQueryRequest.java, v 0.1 2020-07-29 15:50 zhaoyi
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantSubMchQueryRequest extends LeshuaBizRequest<MerchantSubMchQueryResponse> {

    /**
     * 商户编号
     */
    @NotBlank(message = "merchantId不能为空")
    @Length(max = 10, message = "merchantId超长")
    private String merchantId;

    /**
     * 1：微信
     * 2：支付宝
     * 4：银联
     */
    @NotNull(message = "subMchType不能为空")
    private Integer subMchType;


    @Override
    public Class<MerchantSubMchQueryResponse> getResponseClass() {
        return MerchantSubMchQueryResponse.class;
    }

}
