/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.settlement;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 商户款单结果查询request
 *
 * @author zhaoyi
 * @version MerchantSettlementOrderRequest.java, v 0.1 2020-07-30 17:50 zhaoyi
 */
@Data
public class MerchantSettlementOrderRequest implements Serializable {

    private static final long serialVersionUID = -7169629225683059930L;

    /**
     * 单号
     */
    @NotBlank(message = "billId不能为空")
    private String billId;

    /**
     * 类型：“t0”、“t1”、“T1_Adjust”
     */
    @NotBlank(message = "type不能为空")
    private String type;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
