/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.trade.pay.accbusifields.union;

import com.fshows.lakala.request.trade.pay.accbusifields.BaseAccBusiFieldsRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * 银联二维码被扫场景下acc_busi_fields域内容
 *
 * @author liluqing
 * @version AlipayScanCardAccBusiRequest.java, v 0.1 2022-03-07 13:32
 */
@Data
public class UnionScanCardAccBusiRequest extends BaseAccBusiFieldsRequest {

    private static final long serialVersionUID = 9160427020939141549L;

    /**
     * 银联订单信息(暂不支持) (选填)
     * 银联二维码单品营销时上送
     */
    @Length(max = 600, message = "银联订单信息(暂不支持)长度不能超过600")
    private String acqAddnDataOrderInfo;

    /**
     * 银联商品信息(暂不支持) (选填)
     * 银联单品营销商品信息
     */
    @Length(max = 6000, message = "银联商品信息(暂不支持)长度不能超过6000")
    private String acqAddnDataGoodsInfo;

    /**
     * 服务商信息附加信息域，已在拉卡拉配置银联服务商号的需上送，JSON格式
     */
    private String pidInfo;
}