/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.lakala.request.trade.pay;

import com.fshows.lakala.enums.trade.LakalaTradeApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.trade.pay.LakalaBankPayCreateOrderResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 刷卡支付预下单接口（银行卡支付）业务参数
 *
 * @author wangyi
 * @version LakalaBankPayCreateOrderRequest.java, v 0.1 2022-08-21 13:16
 */
@Data
public class LakalaBankPayCreateOrderRequest extends LakalaBizRequest<LakalaBankPayCreateOrderResponse, LakalaTradeApiDefinitionEnum> {

    private static final long serialVersionUID = 1563386158543588642L;
    /**
     * 商户订单号 (必传参数)
     */
    @NotBlank
    private String outOrderNo;

    /**
     * 商户号 (必传参数)
     * 拉卡拉分配的商户号（请求接口中商户号）
     */
    @NotBlank
    @Length(max = 32, message = "商户号长度不能超过32")
    private String merchantNo;

    /**
     * 渠道编号 (必传参数)
     */
    @NotBlank
    private String channelId;

    /**
     * 订单金额，单位：分 范围0~9999999999 (必传参数)
     */
    @NotNull
    private Integer totalAmount;

    /**
     * 订单有效期 格式yyyyMMddHHmmss,最大支持下单时间+2天 (必传参数)
     */
    @NotBlank
    private String orderEfficientTime;

    /**
     * 结算终端号
     */
    private String termNo;

    /**
     * 业务大类信息
     */
    private String busiTypeInfo;

    /**
     * 业务模式： ACQ-收单
     * 默认为“ACQ-收单”
     */
    private String busiMode;

    /**
     * 订单信息
     */
    private String orderInfo;

    /**
     * 附加信息
     */
    private String extendInfo;

    /**
     * 通知地址
     */
    private String notifyUrl;

    /**
     * 是否支持撤销 默认 0 不支持
     */
    private Integer supportCancel;

    /**
     * 是否支持退款 默认0 不支持
     */
    private Integer supportRefund;

    /**
     * 是否支持“多次发起支付” 默认0 不支持
     */
    private Integer supportRepeatPay;

    /**
     * 业务类型控制参数，jsonStr格式
     */
    private String busiTypeParam;
}