/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.lakala.request.merchant;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.merchant.LakalaEcDownloadResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author zhaoxumin
 * @version LakalaEcDownloadRequest.java, v 0.1 2025-09-03 14:36 zhaoxumin
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class LakalaEcDownloadRequest extends LakalaBizRequest<LakalaEcDownloadResponse, LakalaMerchantApiDefinitionEnum> {

    private static final long serialVersionUID = 3260688922948222239L;
    /**
     * 接口版本号 (必填参数)
     * 当前默认 1.0
     */
    @NotBlank
    @Length(max = 8, message = "接口版本号长度不能超过8")
    private String version;

    /**
     * 四方机构自定义订单编号 (必填参数)
     * 建议：平台编号+14位年月日时（24小时制）分秒+8位的随机数（同一接入机构不重复）
     */
    @NotBlank
    @Length(max = 32, message = "订单编号长度不能超过32")
    private String orderNo;

    /**
     * 机构代码 (必填参数)
     */
    @NotNull
    private Integer orgCode;

    /**
     * 电子签约申请受理编号
     */
    @NotNull
    private Long ecApplyId;
}