/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.base;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * @author zhaoxumin
 * @version EcLakalaApiClientImpl.java, v 0.1 2025-09-12 14:36 zhaoxumin
 */
@Data
public class LakalaBaseEcRequest<E extends LakalaBizRequest> extends LakalaBaseRequest {

    private static final long serialVersionUID = 4087760310838856786L;
    /**
     * 请求时间，格式yyyyMMddHHmmss
     */
    @JSONField(name = "req_time")
    private String reqTime;

    /**
     * 版本号
     */
    private String version;

    /**
     * Unix时间戳(毫秒)，13位
     */
    private Long timestamp;

    /**
     * 随机数
     */
    private String rnd;

    /**
     * 业务请求参数
     */
    @JSONField(name = "req_data")
    private E reqData;
}