package com.fshows.lakala.enums.saas;

import com.fshows.lakala.client.base.ILakalaApiDefinition;
import com.fshows.lakala.constant.LakalaConstant;
import com.fshows.lakala.request.saas.LakalaWxAndUnionUserIdRequest;
import com.fshows.lakala.response.saas.LakalaWxAndUnionUserIdResponse;

/**
 * 拉卡拉其他辅助类API
 *
 * @author liluqing
 * @version LakalaMerchantApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum LakalaSaasApiDefinitionEnum implements ILakalaApiDefinition {

    LAKALA_WX_AND_UNION_USERID(
            "微信openid查询&银联userid查询",
            "api/v2/saas/query/wx_openid_query",
            LakalaConstant.SETTLE_API_VERSION_V1,
            LakalaWxAndUnionUserIdRequest.class,
            LakalaWxAndUnionUserIdResponse.class
    );

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本号
     */
    private String version;
    /**
     * 请求Class类型
     */
    private Class requestClass;
    /**
     * 响应Class类型
     */
    private Class responseClass;


    LakalaSaasApiDefinitionEnum(String name,
                                String apiSubURI,
                                String version,
                                Class requestClass,
                                Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}