/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.settle;

import com.fshows.lakala.enums.settle.LakalaSettleApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.settle.LakalaSettleResultQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 结算结果查询请求
 *
 * @author liluqing
 * @version LakalaSettleResultQueryRequest.java, v 0.1 2022-03-08 10:01
 */
@Data
public class LakalaSettleResultQueryRequest extends LakalaBizRequest<LakalaSettleResultQueryResponse, LakalaSettleApiDefinitionEnum> {

    private static final long serialVersionUID = -727852660595907292L;

    /**
     * 机构号 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "机构号长度不能超过32")
    private String instId;

    /**
     * 查询流水号 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "查询流水号长度不能超过32")
    private String queryId;

    /**
     * 分账请求流水id (必填参数)
     * 分账发起方请求唯一标识
     */
    @NotNull
    @Length(max = 32, message = "分账请求流水id长度不能超过32")
    private String ledgerTranSid;

}