/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.lakala.request.merchant;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 *
 * @author liluqing
 * @version LakalaShopDataRequest.java, v 0.1 2023-08-14 17:05
 */
@Data
public class LakalaShopDataRequest {

    /**
     * 网点名称 (选填)
     */
    @Length(max = 64, message = "网点名称长度不能超过64")
    private String shopName;

    /**
     * 网点地址区划代码 (选填)
     */
    @Length(max = 16, message = "网点地址区划代码长度不能超过16")
    private String shopDistCode;

    /**
     * 网点详细地址 (选填)
     */
    @Length(max = 128, message = "网点详细地址长度不能超过128")
    private String shopAddr;

    /**
     * 网点联系人手机号 (选填)
     */
    @Length(max = 32, message = "网点联系人手机号长度不能超过32")
    private String shopContactMobile;

    /**
     * 网点门店联系人名称 (选填)
     */
    @Length(max = 18, message = "网点门店联系人名称长度不能超过18")
    private String shopContactName;
}