/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.lakala.request.merchant;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.merchant.LakalaForeignCardOpenResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * @author mengqf
 * @version LakalaForeignCardOpenRequest.java, v 0.1 2025-05-14 13:36 mengqf
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class LakalaForeignCardOpenRequest extends LakalaBizRequest<LakalaForeignCardOpenResponse, LakalaMerchantApiDefinitionEnum> {
    private static final long serialVersionUID = 8765193257083016802L;

    /**
     * 接口版本号
     */
    private String version;
    /**
     * 订单编号（便于后续跟踪排查问题及核对报文）	接入方编码+14位年月日时（24小时制）分秒+8位的随机数（不重复）如：2021020112000012345678
     */
    private String orderNo;
    /**
     * 机构代码
     */
    private String orgCode;
    /**
     * 商户内部商户号(拉卡拉内部商户号和银联商户号必须传一个，都送以内部商户号为准)	4002019111800000020
     */
    private String merInnerNo;
    /**
     * 银联商户号	82229005411000A
     */
    private String merCupNo;
    /**
     * 银联终端号
     */
    private String termNo;
    /**
     * 回调地址
     */
    private String retUrl;

    /**
     * 商户英文名称
     */
    private String merNameEn;

    /**
     * 商户英文名称简称
     */
    private String merSmallNameEn;

    /**
     * 商户英文城市名称
     */
    private String cityEn;

    /**
     * 商户英文地址名称
     */
    private String merAddrEn;

    /**
     * 附件信息集合
     */
    private Set<LakalaFileDataRequest> fileData;
    /**
     * 费率信息集合
     */
    private Set<LakalaForeignCardFeeRequest> foreignCardFeeList;
}