/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.base;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.util.Date;

/**
 * 拉卡拉请求基类
 *
 * @author liluqing
 * @version LakalaBaseRequest.java, v 0.1 2022-03-02 11:20
 */
@Data
public class LakalaBaseTradeRequest<E extends LakalaBizRequest> extends LakalaBaseRequest {

    private static final long serialVersionUID = -4859881795083961695L;

    /**
     * 请求时间,格式yyyyMMddHHmmss
     */
    @JSONField(format = "yyyyMMddHHmmss")
    private Date reqTime;

    /**
     * 版本号,例如：3.0
     */
    private String version;

    /**
     * 外部接入机构号，即拉卡拉开放平台APPID
     */
    private String outOrgCode;

    /**
     * 业务请求参数
     */
    private E reqData;
}