package com.fshows.lakala.enums.other;

import com.fshows.lakala.client.base.ILakalaApiDefinition;
import com.fshows.lakala.constant.LakalaConstant;
import com.fshows.lakala.request.common.ReplenishUploadFileRequest;
import com.fshows.lakala.request.common.UploadPictureRequest;
import com.fshows.lakala.request.merchant.*;
import com.fshows.lakala.response.common.ReplenishUploadFileResponse;
import com.fshows.lakala.response.common.UploadPictureReponse;
import com.fshows.lakala.response.merchant.*;

/**
 * 拉卡拉商户进件入驻相关API
 *
 * @author liluqing
 * @version LakalaMerchantApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum LakalaOtherApiDefinitionEnum implements ILakalaApiDefinition {

    SSO_LOGIN(
            "联合登陆",
            "api/v3/lams/cashier/sso_login",
            LakalaConstant.MERCHANT_API_VERSION_V3,
            LakalaSsoLoginRequest.class,
            LakalaSsoLoginResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本号
     */
    private String version;
    /**
     * 请求Class类型
     */
    private Class requestClass;
    /**
     * 响应Class类型
     */
    private Class responseClass;


    LakalaOtherApiDefinitionEnum(String name,
                                 String apiSubURI,
                                 String version,
                                 Class requestClass,
                                 Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}
